/*******************************************/
/*  Linearly Interpolating Delay Line      */
/*  Object by Perry R. Cook 1995-96        */
/*  Recoded by John ffitch 1997            */
/*******************************************/

#if !defined(__DLineL_h)
#define __DLineL_h

#include "cs.h"

typedef struct DLineL{
    AUXCH	inputs;
    FLOAT	lastOutput;
    long	inPoint;
    long	outPoint;
    long	length;
    FLOAT	alpha;
    FLOAT	omAlpha;
} DLineL;

#define DLineL_lastOut(d)	((d)->lastOutput)
void make_DLineL(DLineL *, long);  
void DLineL_setDelay(DLineL *, FLOAT);
FLOAT DLineL_tick(DLineL *, FLOAT);

#endif
