/*  ====================================================================== */
/*  Some new Csound opcodes                                                */
/*  Author: Jens Groh, Munich, Germany.   mail: groh@irt.de                */
/*  ====================================================================== */


/* THIS CODE HAS DISPUTED LICENCE AND SO IS NOT DISTRIBUTED *.

typedef double NLALP_MYFLT_TYPE;
typedef struct { /* for nlalp opcode */
   OPDS h; /* header */
   MYFLT *aresult; /* resulting signal */
   MYFLT *ainsig; /* input signal */
   MYFLT *klfact; /* linear factor */
   MYFLT *knfact; /* nonlinear factor */
   MYFLT *istor; /* initial storage disposition */
   MYFLT *iupdm; /* coefficient update mode */

   NLALP_MYFLT_TYPE m0; /* energy storage */
   NLALP_MYFLT_TYPE m1; /* energy storage */
   MYFLT sto_lfact; /* stored linear factor */
   MYFLT sto_nfact; /* stored nonlinear factor */
   MYFLT updm; /* coefficient update mode */
} NLALP;


/*==================================================================*/
/* nlalp                                                            */
/*==================================================================*/

void nlalp_set(NLALP *p)
{
    if (!(*p->istor)) {
      p->m0 = 0.0;
      p->m1 = 0.0;
      p->sto_lfact = 0.0;
      p->sto_nfact = 0.0;
    }
   p->updm = *p->iupdm;
}

void nlalp(NLALP *p)
{
    int nsmps;
    MYFLT *rp;
    MYFLT *ip;
    NLALP_MYFLT_TYPE m0;
    NLALP_MYFLT_TYPE m1;
    NLALP_MYFLT_TYPE tm0;
    NLALP_MYFLT_TYPE tm1;
    NLALP_MYFLT_TYPE lfact;
    NLALP_MYFLT_TYPE nfact;
    NLALP_MYFLT_TYPE posfact;
    NLALP_MYFLT_TYPE negfact;

    nsmps = ksmps;
    rp = p->aresult;
    ip = p->ainsig;
    tm0 = p->m0;
    tm1 = p->m1;
    if (p->updm < 0.0 &&
        (p->sto_lfact != *p->klfact || p->sto_nfact != *p->knfact)) {
      /* wait-for-zero-crossing coefficient updating method */
      lfact = (NLALP_MYFLT_TYPE)p->sto_lfact;
      nfact = (NLALP_MYFLT_TYPE)p->sto_nfact;
      posfact = lfact + nfact;
      negfact = lfact - nfact;
      do {
        m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
        m1 = m0 * (m0 >= 0. ? posfact : negfact);
        *rp++ = (MYFLT)(tm0 + m1);
        if (tm0 <= 0.0 && m0 >= 0.0 ||
            tm0 >= 0.0 && m0 <= 0.0) { /* zero-crossing! */
          tm0 = m0;
          tm1 = m1;
          lfact = (NLALP_MYFLT_TYPE)(p->sto_lfact = *p->klfact); /* update! */
          nfact = (NLALP_MYFLT_TYPE)(p->sto_nfact = *p->knfact); /* update! */
          posfact = lfact + nfact;
          negfact = lfact - nfact;
          while (--nsmps) { /* continue with this loop */
            m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
            m1 = m0 * (m0 >= 0.0 ? posfact : negfact);
            *rp++ = (MYFLT)(tm0 + m1);
            tm0 = m0;
            tm1 = m1;
          }
          break; /* don't continue outer loop */
        }
        tm0 = m0;
        tm1 = m1;
      } while (--nsmps);
    }
    else { /* immediate coefficient updating */
      lfact = (NLALP_MYFLT_TYPE)*p->klfact;
      nfact = (NLALP_MYFLT_TYPE)*p->knfact;
      if (nfact == 0.) { /* linear case */
        if (lfact == 0.) { /* degenerated linear case */
          m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
          *rp++ = (MYFLT)(tm0);
          while (--nsmps) {
            *rp++ = (MYFLT)(m0);
            m0 = (NLALP_MYFLT_TYPE)*ip++;
          }
          tm0 = m0;
          tm1 = 0.0;
        } else { /* normal linear case */
          do {
            m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
            m1 = m0 * lfact;
            *rp++ = (MYFLT)(tm0 + m1);
            tm0 = m0;
            tm1 = m1;
          } while (--nsmps);
        }
      }
      else { /* non-linear case */
        if (lfact == 0.0) { /* simplified non-linear case */
          do {
            m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
            m1 = m0 * (m0 >= 0.0 ? nfact : -nfact); /* was: fabs(m0) * nfact */
            *rp++ = (MYFLT)(tm0 + m1);
            tm0 = m0;
            tm1 = m1;
          } while (--nsmps);
        }
        else { /* normal non-linear case */
          posfact = lfact + nfact;
          negfact = lfact - nfact;
          do {
            m0 = (NLALP_MYFLT_TYPE)*ip++ - tm1;
            m1 = m0 * (m0 >= 0.0 ? posfact : negfact); /* was: m0 * lfact + fabs(m0) * nfact */
            *rp++ = (MYFLT)(tm0 + m1);
            tm0 = m0;
            tm1 = m1;
          } while (--nsmps);
        }
      }
    }
   p->m0 = tm0;
   p->m1 = tm1;
}
