// Dialog for Phase Vocoder Anal

#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include "dialogs.h"

//#define WINVER  0x030a                  // I rely on at least Windows 3.1

#include <afxdlgs.h>
#include <afxwin.h>                     // Main MFC header file

#include "cwin.h"                       // defines external interface

#ifdef BUILDING_DLL
#define DLLexport __declspec(dllexport)
#else
#define DLLexport
#endif

// DisplayMsg is used a bit like fprintf(stderr, ...) but ONLY for debugging.
// It pops up a modal dialog box each time it is called.  This is easy to
// code, but a bit clumsy in the way it distrubs the screen.

extern "C" {
    void DisplayMsg(char *, ...);
}

class Cpvdlg : public CDialog
{
    DECLARE_DYNAMIC(Cpvdlg)

// Construction
  public:
    Cpvdlg(FLOAT sr, int ch, FLOAT beg, FLOAT dur, long frameSize, int ovlp,
	   int frameIncr, int display, int latch);    // standard constructor
// Dialog Data
        //{{AFX_DATA(Cpvdlg)
            FLOAT       m_sr;
            int         m_chan;
            FLOAT       m_beg;
            FLOAT       m_dur;
            long        m_frameSize;
            int         m_ovlp;
            long        m_frameIncr;
            int         m_latch;
            int         m_display;
            CString     m_input;
            CString     m_output;
        //}}AFX_DATA

// Implementation
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  BOOL OnInitDialog(void);
  // Generated message map functions
        //{{AFX_MSG(Cpvdlg)
            afx_msg void OnInput(void);
            afx_msg void OnOutput(void);
            afx_msg void OnCh1(void) { m_chan = 1; }
            afx_msg void OnCh2(void) { m_chan = 2; }
            afx_msg void OnCh3(void) { m_chan = 3; }
            afx_msg void OnCh4(void) { m_chan = 4; }
            afx_msg void OnDisp(void) { m_display = (m_display==0 ? 1 : 0); }
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()

};

IMPLEMENT_DYNAMIC(Cpvdlg, CDialog)

extern LPCTSTR csound_section;

Cpvdlg::Cpvdlg(FLOAT sr, int ch, FLOAT beg, FLOAT dur, long frameSize,
	       int ovlp, int frameIncr, int display, int latch)
        : CDialog("DIALOG_PV", NULL)
{
        //{{AFX_DATA_INIT(Cpvdlg)
    m_sr = sr;
    m_chan = ch;
    m_beg = beg;
    m_dur = dur;
    m_frameSize = frameSize;
    m_ovlp = ovlp;
    m_frameIncr = frameIncr;
    m_latch = latch;
    m_display = display;
    m_input  = theApp.GetProfileString(csound_section, "PVinput", "");
    m_output = theApp.GetProfileString(csound_section, "PVoutput", "test.pv");
        //}}AFX_DATA_INIT
}



BEGIN_MESSAGE_MAP(Cpvdlg, CDialog)
        //{{AFX_MSG_MAP(Cpvdlg)
        ON_COMMAND(P_INPUT, OnInput)
        ON_COMMAND(P_OUTPUT, OnOutput)
        ON_COMMAND(P_C1, OnCh1)
        ON_COMMAND(P_C2, OnCh2)
        ON_COMMAND(P_C3, OnCh3)
        ON_COMMAND(P_C4, OnCh4)
        ON_COMMAND(P_DISP, OnDisp)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void Cpvdlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(Cpvdlg)
    DDX_Text(pDX, P_SAMPLE, m_sr);
    DDV_MinMaxFloat(pDX, m_sr, 0.0f, 100000.0f);
    DDX_Text(pDX, P_BEGIN, m_beg);
    DDV_MinMaxFloat(pDX, m_beg, 0.0f, 1000000.0f);
    DDX_Text(pDX, P_DUR, m_dur);
    DDV_MinMaxFloat(pDX, m_dur, 0.0f, 1000000.0f);
    DDX_Text(pDX, P_FRAME, m_frameSize);
    DDV_MinMaxLong(pDX, m_frameSize, 0, 65536);
//             if (m_frameSize<0 || m_frameSize>20) {
//                 DisplayMsg("Illegal frame size %d"); m_frameSize = 0; }
    DDX_Text(pDX, P_WIND, m_ovlp);
    DDX_Text(pDX, P_HOP, m_frameIncr);
    DDX_Text(pDX, P_LATCH, m_latch);
    DDX_Text(pDX, P_IN, m_input);
    DDX_Text(pDX, P_OUT, m_output);
    if (m_latch) m_display = 1;
        //}}AFX_DATA_MAP
}

void Cpvdlg::OnInput(void)
{
    CFileDialog imp(TRUE, NULL, m_input, OFN_FILEMUSTEXIST,
                    "WAV Files (*.wav)|*.wav|AIFF Files (*.aif; *.aic)|"
		    "*.aif;*.aic|Raw sounds (*.raw)|*.raw|"
		    "All Files (*.*)|*.*||",
                    this);
    if (imp.DoModal() != IDOK) return;
    m_input = imp.GetPathName();
    SetDlgItemText(P_IN, m_input);
    return;
}

void Cpvdlg::OnOutput(void)
{
    CFileDialog imp(TRUE, NULL, m_input, 0,
                    "PV Files (*.pvc)|*.pvc|All Files (*.*)|*.*||",
                    this);
    if (imp.DoModal() != IDOK) return;
    m_output = imp.GetPathName();
    SetDlgItemText(P_OUT, m_output);
    return;
}


BOOL Cpvdlg::OnInitDialog(void)
{
        CDialog::OnInitDialog();
        CheckRadioButton(P_C1, P_C4, P_C1);
        m_sr = 0.0f;
        return TRUE;
}

extern "C" {
  extern int __cdecl pvanal_dialog(FLOAT *, int *, FLOAT *, FLOAT *,
				   long *, int *, long *, int *, int *,
				   char **, char **);
}

static char sconame[256];      // Should be shared with cwin.cpp
static char outname[256];
int __cdecl pvanal_dialog(FLOAT *psr, int *pchannel, FLOAT *pbeg_time,
			  FLOAT *pinput_dur, long *pframe, int *povlp,
			  long *pframeIncr, int *pdisplay, int *platch,
			  char **pinfilnam, char **poutfilnam)
{
    Cpvdlg xxx(*psr,*pchannel,*pbeg_time,*pinput_dur, *pframe,
	       *povlp, *pframeIncr, *pdisplay, *platch);
    if (xxx.DoModal() != IDOK) return 0;
    if (strcmp(xxx.m_input,"")==0) {
        DisplayMsg("No string");
        return 0;
    }
    *psr = xxx.m_sr;
    *pchannel = xxx.m_chan;
    *pbeg_time = xxx.m_beg;
    *pinput_dur = xxx.m_dur;
    *pframe = xxx.m_frameSize;
    *povlp = xxx.m_ovlp;
    *pframeIncr = xxx.m_frameIncr;
    *platch = xxx.m_latch;
    *pdisplay = xxx.m_display;
    strncpy(sconame,xxx.m_input,256);
    *pinfilnam = sconame;
    strncpy(outname,xxx.m_output,256);
    *poutfilnam = outname;
//    DisplayMsg("Data Transferred");
    theApp.WriteProfileString(csound_section, "PVinput", xxx.m_input);
    theApp.WriteProfileString(csound_section, "PVoutput", xxx.m_output);
    return 1;
}


// Add dnoiser here as well

class Cdndlg : public CDialog
{
        DECLARE_DYNAMIC(Cdndlg)

// Construction
public:
        Cdndlg();    // standard constructor
// Dialog Data
        //{{AFX_DATA(Cdndlg)
            FLOAT 	m_thresh; // -t
            int 	m_sharp;  // -s
            FLOAT 	m_gain; // -m
            int 	m_nave; // -n
            FLOAT 	m_begin; // -b
            int 	m_Begin; // -B
            FLOAT 	m_end; // -e
            int 	m_End; // -E
            int 	m_bands; // -N
            int         m_alen; // -M
            int		m_slen; // -L
	    int		m_winding; // -w
            int		m_decim; // -D
            int         m_verbose; // -V
            CString     m_input;
            CString     m_output;
            CString	m_sample;
        //}}AFX_DATA

// Implementation
protected:
        virtual void DoDataExchange(CDataExchange* pDX);
        BOOL OnInitDialog(void);
        // Generated message map functions
        //{{AFX_MSG(Cdndlg)
            afx_msg void OnInput(void);
            afx_msg void OnOutput(void);
            afx_msg void OnSample(void);
            afx_msg void OnVerbose(void) { m_verbose = (m_verbose==0 ? 1 : 0); }
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()

};

IMPLEMENT_DYNAMIC(Cdndlg, CDialog)

extern LPCTSTR csound_section;

Cdndlg::Cdndlg()
        : CDialog("DIALOG_DN", NULL)
{
        //{{AFX_DATA_INIT(Cdndlg)
  m_thresh = 30.0; // -t
  m_sharp = 1;  // -S
  m_gain = -40; // -m
  m_nave = 5; // -n
  m_begin = 0.0; // -b
  m_end = 0.0; // -e
  m_bands = 0; // -N
  m_alen = 0; // -M
  m_slen = 0; // -L
  m_winding = -1; // -w
  m_decim = 0; // -D
  m_verbose = 0; // -V
  m_sample = theApp.GetProfileString(csound_section, "DNoise", "");
  m_input  = theApp.GetProfileString(csound_section, "DNinput", "");
  m_output = theApp.GetProfileString(csound_section, "DNoutput", "test.wav");
        //}}AFX_DATA_INIT
}

BEGIN_MESSAGE_MAP(Cdndlg, CDialog)
        //{{AFX_MSG_MAP(Cdndlg)
        ON_COMMAND(P_INPUT, OnInput)
        ON_COMMAND(P_OUTPUT, OnOutput)
        ON_COMMAND(P_SAMPLE, OnSample)
        ON_COMMAND(P_VERBOSE, OnVerbose)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void Cdndlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(Cdndlg)
	DDX_Text(pDX, P_THRESH, m_thresh);
	DDX_Text(pDX, P_SHARP, m_sharp);
	DDV_MinMaxLong(pDX, m_sharp, 1, 5);
	DDX_Text(pDX, P_GAIN, m_gain);
	DDX_Text(pDX, P_NUM, m_nave); // -n
	DDX_Text(pDX, P_BEGIN, m_begin); // -b
	DDX_Text(pDX, P_END, m_end); // -e
	DDX_Text(pDX, P_BANDS, m_bands);
	DDV_MinMaxLong(pDX, m_bands, 0, 32668);
	DDX_Text(pDX, P_LENGTH, m_slen);
	DDX_Text(pDX, P_OVERLAP, m_winding);
	DDV_MinMaxLong(pDX, m_bands, 0, 3);
	DDX_Text(pDX, P_DECIM, m_decim);
	DDX_Text(pDX, P_IN, m_input);
	DDX_Text(pDX, P_OUT, m_output);
	DDX_Text(pDX, P_INN, m_sample);
        //}}AFX_DATA_MAP
}

void Cdndlg::OnInput(void)
{
    CFileDialog imp(TRUE, NULL, m_input, OFN_FILEMUSTEXIST,
                    "WAV Files (*.wav)|*.wav|AIFF Files (*.aif; *.aic)|"
		    "*.aif;*.aic|Raw sounds (*.raw)|*.raw|"
		    "All Files (*.*)|*.*||",
                    this);
    if (imp.DoModal() != IDOK) return;
    m_input = imp.GetPathName();
    SetDlgItemText(P_IN, m_input);
    return;
}

void Cdndlg::OnSample(void)
{
    CFileDialog imp(TRUE, NULL, m_sample, OFN_FILEMUSTEXIST,
                    "WAV Files (*.wav)|*.wav|AIFF Files (*.aif; *.aic)|"
		    "*.aif;*.aic|Raw sounds (*.raw)|*.raw|"
		    "All Files (*.*)|*.*||",
                    this);
    if (imp.DoModal() != IDOK) return;
    m_sample = imp.GetPathName();
    SetDlgItemText(P_INN, m_sample);
    return;
}

void Cdndlg::OnOutput(void)
{
    CFileDialog imp(TRUE, NULL, m_input, 0,
                    "WAV Files (*.wav)|*.wav|AIFF Files (*.aif; *.aic)|"
		    "*.aif;*.aic|Raw sounds (*.raw)|*.raw|"
		    "All Files (*.*)|*.*||",
                    this);
    if (imp.DoModal() != IDOK) return;
    m_output = imp.GetPathName();
    SetDlgItemText(P_OUT, m_output);
    return;
}


BOOL Cdndlg::OnInitDialog(void)
{
    CDialog::OnInitDialog();
    return TRUE;
}

extern "C" {
    extern int __cdecl dnoise_dialog(FLOAT *, int *, FLOAT *, int *, 
				     FLOAT *, FLOAT *, int *, int *,
				     int *, int *, int *, int *,
				     char **, char **, char **);
}
static char samplename[256];

int __cdecl dnoise_dialog(FLOAT *pth, int *psh, FLOAT *pgn, int *pnave, 
			  FLOAT *pbegin, FLOAT *pend, int *pband, int *palen,
			  int *pslen, int *pwind, int *pdec, int *pveb,
			  char **pinfilnam, char **poutfilnam, char **psample)
{
    Cdndlg xxx;
    if (xxx.DoModal() != IDOK) return 0;
    if (strcmp(xxx.m_input,"")==0) {
        DisplayMsg("No string");
        return 0;
    }
    *pth = xxx.m_thresh; // -t
    *psh = xxx.m_sharp;  // -S
    *pgn = xxx.m_gain; // -m
    *pnave = xxx.m_nave; // -n
    *pbegin = xxx.m_begin; // -b
    *pend = xxx.m_end; // -e
    *pband = xxx.m_bands; // -N
    *palen = xxx.m_alen; // -M
    *pslen = xxx.m_slen; // -L
    *pwind = xxx.m_winding; // -w
    *pdec = xxx.m_decim; // -D
    *pveb = xxx.m_verbose; // -V
    strncpy(sconame,xxx.m_input,256);
    *pinfilnam = sconame;
    strncpy(outname,xxx.m_output,256);
    *poutfilnam = outname;
    strncpy(samplename,xxx.m_sample,256);
    *psample = samplename;
//    DisplayMsg("Data Transferred");
    theApp.WriteProfileString(csound_section, "DNinput", xxx.m_input);
    theApp.WriteProfileString(csound_section, "DNoutput", xxx.m_output);
    theApp.WriteProfileString(csound_section, "DNoise", xxx.m_sample);
    return 1;
}



