/*******************************************/
/*  ADSR Subclass of the Envelope Class,   */
/*  by Perry R. Cook, 1995-96              */ 
/*  This is the traditional ADSR (Attack   */
/*  Decay, Sustain, Release) envelope.     */
/*  It responds to simple KeyOn and KeyOff */
/*  messages, keeping track of it's state. */         
/*  There are two tick (update value)      */
/*  methods, one returns the value, and    */
/*  other returns the state (0 = A, 1 = D, */
/*  2 = S, 3 = R)                          */
/*******************************************/

#if !defined(__ADSR_h)
#define __ADSR_h

#include "envelope.h"

#define ATTACK	(0)
#define DECAY	(1)
#define SUSTAIN (2)
#define RELEASE (3)
#define CLEAR	(4)

typedef struct ADSR {
    FLOAT	value;                /* Envelope subclass */
    FLOAT	target;
    FLOAT	rate;
    int 	state;                  /* end */
    FLOAT	attackRate;
    FLOAT	decayRate;
    FLOAT	sustainLevel;
    FLOAT	releaseRate;
} ADSR;

void make_ADSR(ADSR*);
void dest_ADSR(ADSR*);
void ADSR_keyOn(ADSR*);
void ADSR_keyOff(ADSR*);
void ADSR_setAttackRate(ADSR*, FLOAT);
void ADSR_setDecayRate(ADSR*, FLOAT);
void ADSR_setSustainLevel(ADSR*, FLOAT);
void ADSR_setReleaseRate(ADSR*, FLOAT);
void ADSR_setAll(ADSR*, FLOAT, FLOAT, FLOAT, FLOAT);
void ADSR_setTarget(ADSR*, FLOAT);
void ADSR_setValue(ADSR*, FLOAT);
FLOAT ADSR_tick(ADSR*);
int ADSR_informTick(ADSR*);  
FLOAT ADSR_lastOut(ADSR*);

#endif
